<?php
session_start();
include 'includes/auth.php';
include 'includes/db.php';

if (!isset($_GET['member_id']) || !is_numeric($_GET['member_id'])) {
    echo "<p class='text-danger'>Invalid member ID.</p>";
    exit;
}

$member_id = (int)$_GET['member_id'];

$query = mysqli_query($conn, "
    SELECT warning_level, reason, details, action_required, consequences, issued_by, issued_date
    FROM warnings
    WHERE member_id = $member_id
    ORDER BY issued_date DESC
");

if (mysqli_num_rows($query) === 0) {
    echo "<p>No warnings found for this member.</p>";
} else {
    echo "<div class='table-responsive'>";
    echo "<table class='table table-bordered'>";
    echo "<thead><tr>
            <th>Level</th>
            <th>Reason</th>
            <th>Details</th>
            <th>Action Required</th>
            <th>Consequences</th>
            <th>Issued By</th>
            <th>Date</th>
          </tr></thead><tbody>";

    while ($row = mysqli_fetch_assoc($query)) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['warning_level']) . "</td>";
        echo "<td>" . htmlspecialchars($row['reason']) . "</td>";
        echo "<td>" . nl2br(htmlspecialchars($row['details'])) . "</td>";
        echo "<td>" . htmlspecialchars($row['action_required']) . "</td>";
        echo "<td>" . htmlspecialchars($row['consequences']) . "</td>";
        echo "<td>" . htmlspecialchars($row['issued_by']) . "</td>";
        echo "<td>" . htmlspecialchars(date('d/m/Y', strtotime($row['issued_date']))) . "</td>";
        echo "</tr>";
    }

    echo "</tbody></table>";
    echo "</div>";
}
?>
